/*
 * Decompiled with CFR 0.152.
 */
package com.zee.unity.camera2;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import android.view.TextureView;
import com.zee.unity.HardwareInfo;
import com.zee.unity.camera2.Camera2Listener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class Camera2Helper {
    private static final String TAG = "Camera2Helper";
    public static final String CAMERA_ID_FRONT = "1";
    public static final String CAMERA_ID_BACK = "0";
    private final int resolutionIndex = 0;
    private Size[] resolutions = new Size[]{new Size(1920, 1080), new Size(640, 480)};
    private String mCameraId;
    private String specificCameraId;
    private Camera2Listener camera2Listener;
    private TextureView mTextureView;
    private int rotation;
    private Point previewViewSize;
    private Point specificPreviewSize;
    private boolean isMirror;
    private Context context;
    private int bitmapOri = 0;
    public boolean runClassifier = false;
    private double scale = 0.0;
    private long costTime;
    private long frameCounts = 0L;
    private Bitmap mBitmap = null;
    private int imgWidth = 480;
    private int imgHeight = 640;
    private static final String HANDLE_THREAD_NAME = "CameraBackground";
    private CameraCaptureSession mCaptureSession;
    private CameraDevice mCameraDevice;
    private Size mPreviewSize;
    private static Range<Integer>[] fpsRanges;
    public final TextureView.SurfaceTextureListener mSurfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture texture, int width, int height) {
            Log.i((String)Camera2Helper.TAG, (String)("onSurfaceTextureAvailable: width=" + width + ", height=" + height));
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture texture, int width, int height) {
            Log.i((String)Camera2Helper.TAG, (String)("onSurfaceTextureSizeChanged: width=" + width + ", height=" + height));
            if (Camera2Helper.this.mCameraDevice != null) {
                Camera2Helper.this.configureTransform(width, height);
            }
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture texture) {
            Log.i((String)Camera2Helper.TAG, (String)"onSurfaceTextureDestroyed: ");
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture texture) {
        }
    };
    private CameraDevice.StateCallback mDeviceStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(CameraDevice cameraDevice) {
            Log.i((String)Camera2Helper.TAG, (String)"onOpened: ");
            Camera2Helper.this.mCameraOpenCloseLock.release();
            Camera2Helper.this.mCameraDevice = cameraDevice;
            Camera2Helper.this.createCameraPreviewSession();
            if (Camera2Helper.this.camera2Listener != null) {
                Camera2Helper.this.camera2Listener.onCameraOpened(cameraDevice, Camera2Helper.this.mCameraId, Camera2Helper.this.mPreviewSize, Camera2Helper.this.getCameraOri(Camera2Helper.this.rotation, Camera2Helper.this.mCameraId), Camera2Helper.this.isMirror);
            }
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            Log.i((String)Camera2Helper.TAG, (String)"onDisconnected: ");
            Camera2Helper.this.mCameraOpenCloseLock.release();
            cameraDevice.close();
            Camera2Helper.this.mCameraDevice = null;
            if (Camera2Helper.this.camera2Listener != null) {
                Camera2Helper.this.camera2Listener.onCameraClosed();
            }
        }

        public void onError(CameraDevice cameraDevice, int error) {
            Log.i((String)Camera2Helper.TAG, (String)"onError: ");
            Camera2Helper.this.mCameraOpenCloseLock.release();
            cameraDevice.close();
            Camera2Helper.this.mCameraDevice = null;
            if (Camera2Helper.this.camera2Listener != null) {
                Camera2Helper.this.camera2Listener.onCameraError(new Exception("error occurred, code is " + error));
            }
        }
    };
    private CameraCaptureSession.StateCallback mCaptureStateCallback = new CameraCaptureSession.StateCallback(){

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            Log.i((String)Camera2Helper.TAG, (String)"onConfigured: ");
            if (null == Camera2Helper.this.mCameraDevice) {
                return;
            }
            Camera2Helper.this.mCaptureSession = cameraCaptureSession;
            try {
                Camera2Helper.this.mCaptureSession.setRepeatingRequest(Camera2Helper.this.mPreviewRequestBuilder.build(), new CameraCaptureSession.CaptureCallback(){}, Camera2Helper.this.mBackgroundHandler);
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
            }
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            Log.i((String)Camera2Helper.TAG, (String)"onConfigureFailed: ");
            if (Camera2Helper.this.camera2Listener != null) {
                Camera2Helper.this.camera2Listener.onCameraError(new Exception("configureFailed"));
            }
        }
    };
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    private CaptureRequest.Builder mPreviewRequestBuilder;
    private Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private int mSensorOrientation;
    private Runnable periodicClassify = () -> {
        if (this.runClassifier) {
            this.classifyFrame();
        }
    };
    long lastTimestamp = 0L;

    private Camera2Helper(Builder builder) {
        this.mTextureView = builder.previewDisplayView;
        this.mTextureView.setSurfaceTextureListener(this.mSurfaceTextureListener);
        this.specificCameraId = builder.specificCameraId;
        this.camera2Listener = builder.camera2Listener;
        this.rotation = builder.rotation;
        this.previewViewSize = builder.previewViewSize;
        this.specificPreviewSize = builder.previewSize;
        this.isMirror = builder.isMirror;
        this.context = builder.context;
        if (this.isMirror) {
            this.mTextureView.setScaleX(-1.0f);
        }
    }

    public int getCameraOri(int rotation, String cameraId) {
        int result;
        int degrees = rotation * 90;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
                break;
            }
        }
        if (CAMERA_ID_FRONT.equals(cameraId)) {
            result = (this.mSensorOrientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (this.mSensorOrientation - degrees + 360) % 360;
        }
        Log.i((String)TAG, (String)("getCameraOri: " + rotation + " " + result + " " + this.mSensorOrientation));
        this.camera2Listener.setRotAngle(result);
        return result;
    }

    private Size getBestSupportedSize(List<Size> sizes) {
        Size[] tempSizes = sizes.toArray(new Size[0]);
        Arrays.sort(tempSizes, new Comparator<Size>(){

            @Override
            public int compare(Size o1, Size o2) {
                if (o1.getWidth() > o2.getWidth()) {
                    return -1;
                }
                if (o1.getWidth() == o2.getWidth()) {
                    return o1.getHeight() > o2.getHeight() ? -1 : 1;
                }
                return 1;
            }
        });
        sizes = Arrays.asList(tempSizes);
        boolean support480P = false;
        boolean support1080P = false;
        for (Size size : sizes) {
            Log.e((String)TAG, (String)("size.getWidth()=" + size.getWidth() + ", size.getHeight()=" + size.getHeight()));
            if (size.getHeight() == 480 && size.getWidth() == 640) {
                support480P = true;
            }
            if (size.getHeight() != 1080 || size.getWidth() != 1920) continue;
            support1080P = true;
        }
        if (!support480P && !support1080P) {
            Log.e((String)TAG, (String)"error! not support sizes of what we set");
        } else if (!support1080P) {
            Log.e((String)TAG, (String)"error! only not support 1920x1080");
        } else if (!support480P) {
            Log.e((String)TAG, (String)"error! only not support 640x480");
        }
        int screenHeight = this.mTextureView.getLayoutParams().height;
        int screenWidth = this.mTextureView.getLayoutParams().width;
        if (screenWidth < 640) {
            Log.e((String)TAG, (String)"error! screen resolution < 640x480");
        } else if (screenWidth < 1920) {
            Log.e((String)TAG, (String)"error! screen resolution < 1920x1080");
        }
        return this.resolutions[0];
    }

    public void start(String cameraId) {
        if (this.mCameraDevice != null) {
            return;
        }
        this.startBackgroundThread();
        this.specificCameraId = cameraId;
        if (this.mTextureView.isAvailable()) {
            this.openCamera();
        } else {
            Log.d((String)TAG, (String)"start mTextureView isAvailable false");
        }
    }

    public void stop() {
        if (this.mCameraDevice == null) {
            return;
        }
        this.mBitmap.recycle();
        this.mBitmap = null;
        this.closeCamera();
        this.stopBackgroundThread();
    }

    public void release() {
        this.stop();
        this.mTextureView = null;
        this.camera2Listener = null;
        this.context = null;
    }

    private void setUpCameraOutputs(CameraManager cameraManager) {
        block5: {
            try {
                if (this.configCameraParams(cameraManager, this.specificCameraId)) {
                    return;
                }
                for (String cameraId : cameraManager.getCameraIdList()) {
                    if (!this.configCameraParams(cameraManager, cameraId)) continue;
                    return;
                }
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                if (this.camera2Listener == null) break block5;
                this.camera2Listener.onCameraError(e);
            }
        }
    }

    @SuppressLint(value={"WrongConstant"})
    private boolean configCameraParams(CameraManager manager, String cameraId) throws CameraAccessException {
        CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId);
        fpsRanges = (Range[])characteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (map == null) {
            return false;
        }
        this.mPreviewSize = this.getBestSupportedSize(new ArrayList<Size>(Arrays.asList(map.getOutputSizes(SurfaceTexture.class))));
        this.mSensorOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.mCameraId = cameraId;
        return true;
    }

    @SuppressLint(value={"MissingPermission"})
    private void openCamera() {
        block5: {
            CameraManager cameraManager = (CameraManager)this.context.getSystemService("camera");
            this.setUpCameraOutputs(cameraManager);
            this.configureTransform(this.mTextureView.getWidth(), this.mTextureView.getHeight());
            try {
                if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                    throw new RuntimeException("Time out waiting to lock camera opening.");
                }
                cameraManager.openCamera(this.mCameraId, this.mDeviceStateCallback, this.mBackgroundHandler);
            }
            catch (CameraAccessException e) {
                if (this.camera2Listener != null) {
                    this.camera2Listener.onCameraError((Exception)((Object)e));
                }
            }
            catch (InterruptedException e) {
                if (this.camera2Listener == null) break block5;
                this.camera2Listener.onCameraError(e);
            }
        }
    }

    private void closeCamera() {
        try {
            this.mCameraOpenCloseLock.acquire();
            if (null != this.mCaptureSession) {
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            if (null != this.mCameraDevice) {
                this.mCameraDevice.close();
                this.mCameraDevice = null;
            }
            if (this.camera2Listener != null) {
                this.camera2Listener.onCameraClosed();
            }
        }
        catch (InterruptedException e) {
            if (this.camera2Listener != null) {
                this.camera2Listener.onCameraError(e);
            }
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
    }

    private void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread(HANDLE_THREAD_NAME);
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
        this.runClassifier = true;
        this.mBackgroundHandler.post(this.periodicClassify);
    }

    private void stopBackgroundThread() {
        try {
            this.runClassifier = false;
            this.mBackgroundThread.quitSafely();
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler.removeCallbacksAndMessages(null);
            this.mBackgroundHandler = null;
            double perFrameTime = (double)this.costTime / (double)this.frameCounts;
            Log.d((String)TAG, (String)("\u82b1\u8d39\u65f6\u95f4\uff1a" + this.costTime + "ms \u603b\u5e27\u6570\uff1a" + this.frameCounts + " \u6bcf\u5e27\u82b1\u8d39\u65f6\u95f4\uff1a" + perFrameTime));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void classifyFrame() {
        if (this.mTextureView.isAvailable()) {
            long currentTimestamp = this.mTextureView.getSurfaceTexture().getTimestamp();
            if (this.lastTimestamp == currentTimestamp) {
                this.mBackgroundHandler.post(this.periodicClassify);
                return;
            }
            this.lastTimestamp = currentTimestamp;
            this.mBitmap = this.mTextureView.getBitmap(this.imgWidth, this.imgHeight);
            if (this.mBitmap != null) {
                if (!HardwareInfo.AMLOGIC) {
                    this.mBitmap = this.adjustPhotoRotation(this.mBitmap);
                }
                this.camera2Listener.method(this.mBitmap);
            }
        }
        this.mBackgroundHandler.post(this.periodicClassify);
    }

    private Bitmap adjustPhotoRotation(Bitmap bm) {
        Matrix m = new Matrix();
        m.setRotate(90.0f, (float)bm.getWidth() / 2.0f, (float)bm.getHeight() / 2.0f);
        try {
            bm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)m, (boolean)true);
            return bm;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
    }

    public void setZeePoseEnable(boolean isEnable) {
        this.runClassifier = isEnable;
        if (this.mBackgroundHandler != null) {
            if (isEnable) {
                this.mBackgroundHandler.removeCallbacksAndMessages(null);
                this.mBackgroundHandler.post(this.periodicClassify);
            } else {
                this.mBackgroundHandler.removeCallbacksAndMessages(null);
            }
        }
    }

    private void createCameraPreviewSession() {
        try {
            SurfaceTexture texture = this.mTextureView.getSurfaceTexture();
            assert (texture != null);
            Log.d((String)TAG, (String)("mPreviewSize: h: " + this.mPreviewSize.getHeight() + " w: " + this.mPreviewSize.getWidth()));
            texture.setDefaultBufferSize(this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight());
            Surface surface = new Surface(texture);
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            Log.d((String)TAG, (String)("fpsRanges: Lower: " + fpsRanges[0].getLower() + " Upper: " + fpsRanges[0].getUpper()));
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15)));
            this.mPreviewRequestBuilder.addTarget(surface);
            this.mCameraDevice.createCaptureSession(Arrays.asList(surface), this.mCaptureStateCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void configureTransform(int viewWidth, int viewHeight) {
        if (null == this.mTextureView || null == this.mPreviewSize) {
            return;
        }
        Matrix matrix = new Matrix();
        RectF viewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        RectF bufferRect = new RectF(0.0f, 0.0f, (float)this.mPreviewSize.getHeight(), (float)this.mPreviewSize.getWidth());
        float centerX = viewRect.centerX();
        float centerY = viewRect.centerY();
        if (1 == this.rotation || 3 == this.rotation) {
            bufferRect.offset(centerX - bufferRect.centerX(), centerY - bufferRect.centerY());
            matrix.setRectToRect(viewRect, bufferRect, Matrix.ScaleToFit.FILL);
            float scale = Math.max((float)viewHeight / (float)this.mPreviewSize.getHeight(), (float)viewWidth / (float)this.mPreviewSize.getWidth());
            matrix.postRotate((float)(90 * (this.rotation - 2) % 360), centerX, centerY);
        } else if (2 == this.rotation) {
            matrix.postRotate(180.0f, centerX, centerY);
        }
        Log.i((String)TAG, (String)("configureTransform: " + this.getCameraOri(this.rotation, this.mCameraId) + "  " + this.rotation * 90 + "  " + matrix));
        this.mTextureView.setTransform(matrix);
    }

    public void changeCamera(String cameraId) {
        this.specificCameraId = cameraId;
    }

    public void changeRotation(int rotation) {
        this.rotation = rotation;
    }

    public void setBitmapOri(int bitmapOri) {
        this.bitmapOri = bitmapOri;
    }

    public void setImgHeight(int imgHeight) {
        this.imgHeight = imgHeight;
    }

    public void setImgWidth(int imgWidth) {
        this.imgWidth = imgWidth;
    }

    public int getImgWidth() {
        int width = this.mPreviewSize.getWidth();
        int height = this.mPreviewSize.getHeight();
        int commonDivisor = this.getCommonDivisor(width, height);
        int bestCommonMultiple = this.getBestCommonMultiple(width /= commonDivisor, height /= commonDivisor);
        this.imgHeight = bestCommonMultiple * height;
        this.imgWidth = bestCommonMultiple * width;
        Log.d((String)TAG, (String)("imgHeight: " + this.imgHeight + " imgWidth: " + this.imgWidth));
        return this.imgWidth;
    }

    public int getImgHeight() {
        int width = this.mPreviewSize.getWidth();
        int height = this.mPreviewSize.getHeight();
        int commonDivisor = this.getCommonDivisor(width, height);
        int bestCommonMultiple = this.getBestCommonMultiple(width /= commonDivisor, height /= commonDivisor);
        this.imgHeight = bestCommonMultiple * width;
        this.imgWidth = bestCommonMultiple * height;
        Log.d((String)TAG, (String)("imgHeight: " + this.imgHeight + " imgWidth: " + this.imgWidth));
        return this.imgHeight;
    }

    private int getCommonDivisor(int m, int n) {
        if (m <= 0 || n <= 0) {
            return -1;
        }
        if (m < n) {
            int temp = m;
            m = n;
            n = temp;
        }
        int c = m % n;
        while (c != 0) {
            m = n;
            n = c;
            c = m % n;
        }
        return n;
    }

    private int getBestCommonMultiple(int m, int n) {
        if (m <= 0 || n <= 0) {
            return -1;
        }
        if (m < n) {
            m = n;
        }
        int temp = m;
        int i = 1;
        while (temp <= this.imgHeight) {
            temp = ++i * m;
        }
        return --i;
    }

    public static final class Builder {
        private TextureView previewDisplayView;
        private boolean isMirror;
        private String specificCameraId;
        private Camera2Listener camera2Listener;
        private Point previewViewSize;
        private int rotation;
        private Point previewSize;
        private Context context;

        public Builder previewOn(TextureView val) {
            this.previewDisplayView = val;
            return this;
        }

        public Builder isMirror(boolean val) {
            this.isMirror = val;
            return this;
        }

        public Builder previewSize(Point val) {
            this.previewSize = val;
            return this;
        }

        public Builder previewViewSize(Point val) {
            this.previewViewSize = val;
            return this;
        }

        public Builder rotation(int val) {
            this.rotation = val;
            return this;
        }

        public Builder specificCameraId(String val) {
            this.specificCameraId = val;
            return this;
        }

        public Builder cameraListener(Camera2Listener val) {
            this.camera2Listener = val;
            return this;
        }

        public Builder context(Context val) {
            this.context = val;
            return this;
        }

        public Camera2Helper build() {
            if (this.previewViewSize == null) {
                Log.e((String)Camera2Helper.TAG, (String)"previewViewSize is null, now use default previewSize");
            }
            if (this.camera2Listener == null) {
                Log.e((String)Camera2Helper.TAG, (String)"camera2Listener is null, callback will not be called");
            }
            if (this.previewDisplayView == null) {
                throw new RuntimeException("you must preview on a textureView or a surfaceView");
            }
            return new Camera2Helper(this);
        }
    }
}

