/*
 * Decompiled with CFR 0.152.
 */
package com.zee.unity;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.hardware.camera2.CameraDevice;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Size;
import android.view.KeyEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.unity3d.player.UnityPlayer;
import com.unity3d.player.UnityPlayerActivity;
import com.zee.unity.AuthInfo;
import com.zee.unity.HardwareInfo;
import com.zee.unity.LocationEnum;
import com.zee.unity.Overlay;
import com.zee.unity.R;
import com.zee.unity.UnityHelper;
import com.zee.unity.camera2.Camera2Helper;
import com.zee.unity.camera2.Camera2Listener;
import com.zee.unity.config.Config;
import com.zee.unity.model.ZeePoseWrapper;
import com.zee.unity.utils.CommonUtils;
import com.zeewain.zeepose.FaceInfo;
import com.zeewain.zeepose.HandInfo;
import com.zeewain.zeepose.HolisticInfo;
import com.zeewain.zeepose.PoseInfo;
import com.zeewain.zeepose.ZeewainPose;
import com.zeewain.zeepose.ZwnConfig;
import com.zeewain.zeepose.base.Rect;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

public class ZeeUnityActivity
extends UnityPlayerActivity
implements ViewTreeObserver.OnGlobalLayoutListener,
Camera2Listener {
    private static final String TAG = "ZeeUnity";
    private FrameLayout frameLayout;
    private TextureView textureView;
    private Overlay overlay;
    private AuthInfo unityAuthInfo = null;
    private String hostPkg;
    public Camera2Helper camera2Helper;
    public final ZeewainPose zeewainPose = new ZeewainPose();
    private String modelsDirPath;
    private final int REQUEST_CODE_PERMISSIONS = 1;
    private final String[] REQUIRED_PERMISSIONS = new String[]{"android.permission.CAMERA"};
    private float scalew = 1.0f;
    private boolean isSetTexture2 = true;
    private int rotation = 0;
    private int screenWidth = 1920;
    private int screenHeight = 1080;
    private float xOffset = 0.0f;
    private float yOffset = 0.0f;
    private int initZeeResult = -1;
    private LocationEnum locationEnum = null;
    public boolean useBestPose = false;
    private FaceInfo[] faceInfoArray;
    private FaceInfo[] faceInfoOverlayArray;
    private FaceInfo[] faceInfoOrgArray;
    private HandInfo[] handInfoArray;
    private HandInfo[] handInfoOverlayArray;
    private HandInfo[] handInfoOrgArray;
    private PoseInfo[] poseInfoArray;
    private PoseInfo[] poseInfoOverlayArray;
    private PoseInfo[] poseInfoOrgArray;
    private HolisticInfo holisticInfo;
    public int[] trackIdArray = null;
    public Rect roiPersonTrackRect = null;
    private boolean debugAndroid = false;
    private float androidU3dScale = 1.0f;

    public boolean authZeeWainPose(String ak, String sk, String url) {
        String licensePath = this.getExternalFilesDir("").getAbsolutePath() + File.separator + "zeewain.json";
        return this.zeewainPose.setAuthOnline(ak, sk, url, licensePath) == 0;
    }

    public int initPersonPose(int modelType, int deviceType, int threadNum, boolean useBestPose) {
        this.useBestPose = useBestPose;
        ZwnConfig zwnConfig = new ZwnConfig(this.modelsDirPath, deviceType, threadNum, modelType);
        this.initZeeResult = this.zeewainPose.initPose(zwnConfig);
        this.locationEnum = LocationEnum.PERSONPOSE;
        return this.initZeeResult;
    }

    public int initSinglePose(int modelType, int deviceType, int threadNum) {
        this.initZeeResult = this.zeewainPose.initSinglePose(new ZwnConfig(this.modelsDirPath, deviceType, threadNum, modelType));
        this.locationEnum = LocationEnum.SINGLEPOSE;
        return this.initZeeResult;
    }

    public int initFace(int modelType, int deviceType, int threadNum) {
        this.initZeeResult = this.zeewainPose.initFace(new ZwnConfig(this.modelsDirPath, deviceType, threadNum, modelType));
        this.locationEnum = LocationEnum.FACE;
        return this.initZeeResult;
    }

    public int initHand(int modelType, int deviceType, int threadNum) {
        this.initZeeResult = this.zeewainPose.initHand(new ZwnConfig(this.modelsDirPath, deviceType, threadNum, modelType));
        this.locationEnum = LocationEnum.HAND;
        return this.initZeeResult;
    }

    public int initHolistic(int modelType, int deviceType, int threadNum) {
        this.initZeeResult = this.zeewainPose.initHolistic(new ZwnConfig(this.modelsDirPath, deviceType, threadNum, modelType));
        this.locationEnum = LocationEnum.HOLISTIC;
        return this.initZeeResult;
    }

    public int initSegment(int modelType, int deviceType, int threadNum) {
        this.initZeeResult = this.zeewainPose.initSegment(new ZwnConfig(this.modelsDirPath, deviceType, threadNum, modelType));
        this.locationEnum = LocationEnum.SEGMENT;
        return this.initZeeResult;
    }

    public void releaseZee() {
        if (this.initZeeResult == 0) {
            this.initZeeResult = -1;
            if (LocationEnum.PERSONPOSE == this.locationEnum) {
                this.zeewainPose.releasePose();
            } else if (LocationEnum.SINGLEPOSE == this.locationEnum) {
                this.zeewainPose.releaseSinglePose();
            } else if (LocationEnum.FACE == this.locationEnum) {
                this.zeewainPose.releaseFace();
            } else if (LocationEnum.HAND == this.locationEnum) {
                this.zeewainPose.releaseHand();
            } else if (LocationEnum.HOLISTIC == this.locationEnum) {
                this.zeewainPose.releaseHolistic();
            } else if (LocationEnum.SEGMENT == this.locationEnum) {
                this.zeewainPose.releaseSegment();
            }
            this.locationEnum = null;
        }
    }

    public void setTextureViewAlpha(float alpha) {
        this.runOnUiThread(() -> this.textureView.setAlpha(alpha));
    }

    public void initUnityScreenSize(float width, float height, String fitSide) {
        this.androidU3dScale = 1.0f;
        if (fitSide.equals("height")) {
            this.androidU3dScale = height / (float)this.textureView.getLayoutParams().height;
        }
        if (fitSide.equals("width")) {
            this.androidU3dScale = width / (float)this.textureView.getLayoutParams().width;
        }
    }

    private void buildAkSkInfo() {
        this.hostPkg = this.getIntent().getStringExtra("HostPkg");
        if (this.hostPkg == null || this.hostPkg.isEmpty()) {
            this.hostPkg = this.getPackageName();
        }
        this.modelsDirPath = this.getIntent().getStringExtra("ModelsDirPath");
        String akCode = this.getIntent().getStringExtra("AuthAkCode");
        String skCode = this.getIntent().getStringExtra("AuthSkCode");
        String authUri = this.getIntent().getStringExtra("AuthUri");
        String authToken = this.getIntent().getStringExtra("AuthToken");
        Log.i((String)TAG, (String)("onCreate() ** akCode=" + akCode + ", skCode=" + skCode + ", hostPkg=" + this.hostPkg + ", authUri=" + authUri + ", authToken=" + authToken + ", modelsDirPath=" + this.modelsDirPath));
        this.unityAuthInfo = akCode == null || akCode.isEmpty() || authToken == null || authToken.isEmpty() ? null : new AuthInfo(akCode, skCode, this.hostPkg, authUri, authToken);
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.getWindow().setFlags(0x1000000, 0x1000000);
        super.onCreate(savedInstanceState);
        this.rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        this.buildAkSkInfo();
        this.setContentView(R.layout.activity_zee_unity);
        boolean isDone = false;
        if (this.modelsDirPath == null || this.modelsDirPath.isEmpty()) {
            this.modelsDirPath = this.getFilesDir() + File.separator;
            isDone = CommonUtils.copyFilesFromAssetsTo((Context)this, this.zeewainPose.getModelNameLists(), this.modelsDirPath);
            if (!isDone) {
                Log.e((String)TAG, (String)"\u62f7\u8d1d\u6a21\u578b\u5931\u8d25\uff01");
                this.showToast("\u62f7\u8d1d\u6a21\u578b\u5931\u8d25\uff01");
                this.finish();
                return;
            }
        }
        if (this.unityAuthInfo != null) {
            isDone = this.authZeeWainPose(this.unityAuthInfo.getAkCode(), this.unityAuthInfo.getSkCode(), this.unityAuthInfo.getAuthUri());
        } else {
            Log.e((String)TAG, (String)"unityAuthInfo is null, use default config info");
            isDone = this.authZeeWainPose(Config.ak, Config.sk, Config.url);
        }
        if (!isDone) {
            Log.e((String)TAG, (String)"\u5728\u7ebf\u6388\u6743\u5931\u8d25\uff01");
            this.showToast("\u5728\u7ebf\u6388\u6743\u5931\u8d25\uff01");
            this.finish();
            return;
        }
        Log.i((String)TAG, (String)("zeewainPose version " + this.zeewainPose.getVersionInfo()));
        HardwareInfo.init();
        UnityHelper.init(this);
        this.frameLayout = (FrameLayout)this.findViewById(R.id.fl_root);
        this.textureView = (TextureView)this.findViewById(R.id.textureView);
        this.textureView.setAlpha(0.0f);
        this.overlay = (Overlay)this.findViewById(R.id.overlay);
        this.overlay.initOverlay(LocationEnum.PERSONPOSE);
        this.frameLayout.addView((View)this.mUnityPlayer);
        this.initScreenSize();
        if (this.debugAndroid) {
            this.addDebugBtn();
        }
        this.mUnityPlayer.requestFocus();
        this.textureView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private void addDebugBtn() {
        LinearLayout linearLayout = new LinearLayout((Context)this);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout.setOrientation(0);
        linearLayout.setGravity(1);
        linearLayout.setBackgroundColor(1724688896);
        Button button = new Button((Context)this);
        button.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        button.setText((CharSequence)"\u5f00\u542f\u76f8\u673a");
        button.setOnClickListener(v -> {
            if (HardwareInfo.AMLOGIC) {
                UnityHelper.openCamera("0");
            } else {
                UnityHelper.openCamera("1");
            }
        });
        linearLayout.addView((View)button);
        Button button2 = new Button((Context)this);
        button2.setText((CharSequence)"\u5173\u95ed\u76f8\u673a");
        button2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        button2.setOnClickListener(v -> UnityHelper.closeCamera());
        linearLayout.addView((View)button2);
        Button button3 = new Button((Context)this);
        button3.setText((CharSequence)"\u521d\u59cb\u5316\u4eba\u8138");
        button3.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        button3.setOnClickListener(v -> UnityHelper.initFace(0, 1, 1));
        linearLayout.addView((View)button3);
        Button button4 = new Button((Context)this);
        button4.setText((CharSequence)"\u521d\u59cb\u5316\u4eba\u624b");
        button4.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        button4.setOnClickListener(view -> UnityHelper.initHand(0, 1, 1));
        linearLayout.addView((View)button4);
        Button button5 = new Button((Context)this);
        button5.setText((CharSequence)"\u521d\u59cb\u5316\u9aa8\u9abc");
        button5.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        button5.setOnClickListener(view -> UnityHelper.initPersonPose(0, 1, 1, true));
        linearLayout.addView((View)button5);
        Button button6 = new Button((Context)this);
        button6.setText((CharSequence)"\u91ca\u653e\u8d44\u6e90");
        button6.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        button6.setOnClickListener(view -> UnityHelper.releaseZeePose());
        linearLayout.addView((View)button6);
        Button button7 = new Button((Context)this);
        button7.setText((CharSequence)"Alpha");
        button7.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        button7.setOnClickListener(view -> UnityHelper.setTextureViewAlpha(1.0f));
        linearLayout.addView((View)button7);
        this.frameLayout.addView((View)linearLayout);
    }

    void initScreenSize() {
        DisplayMetrics outMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getRealMetrics(outMetrics);
        this.screenHeight = outMetrics.heightPixels;
        this.screenWidth = outMetrics.widthPixels;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 1) {
            Log.i((String)TAG, (String)"onRequestPermissionsResult() ***  *** ");
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.initCamera();
            } else {
                this.showToast("Permissions not granted by the user.");
                this.finish();
            }
        }
    }

    private void initCamera() {
        Log.d((String)TAG, (String)("textureView w:" + this.textureView.getLayoutParams().width + " h:" + this.textureView.getLayoutParams().height));
        this.camera2Helper = new Camera2Helper.Builder().cameraListener(this).specificCameraId("1").context(this.getApplicationContext()).previewOn(this.textureView).previewViewSize(new Point(this.textureView.getLayoutParams().width, this.textureView.getLayoutParams().height)).rotation(this.rotation).build();
        this.sendCameraStatus(0);
    }

    public void onGlobalLayout() {
        Log.d((String)TAG, (String)"\u56de\u8c03\u4e86onGlobalLayout()");
        this.textureView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        ViewGroup.LayoutParams layoutParams1 = this.textureView.getLayoutParams();
        layoutParams1.width = this.screenWidth;
        layoutParams1.height = this.screenHeight;
        this.textureView.setLayoutParams(layoutParams1);
        ViewGroup.LayoutParams layoutParams2 = this.frameLayout.getLayoutParams();
        layoutParams2.width = this.screenWidth;
        layoutParams2.height = this.screenHeight;
        this.frameLayout.setLayoutParams(layoutParams2);
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestPermissions(this.REQUIRED_PERMISSIONS, 1);
        }
    }

    @Override
    public void onCameraOpened(CameraDevice cameraDevice, String cameraId, Size previewSize, int displayOrientation, boolean isMirror) {
        this.runOnUiThread(() -> {
            this.sendCameraStatus(1);
            if (this.isSetTexture2) {
                ViewGroup.LayoutParams layoutParams = this.textureView.getLayoutParams();
                if (previewSize.getWidth() > this.screenWidth || previewSize.getHeight() > this.screenHeight) {
                    layoutParams.width = (int)((float)layoutParams.height * ((float)previewSize.getWidth() / (float)previewSize.getHeight()));
                    this.xOffset = (float)(previewSize.getWidth() - layoutParams.width) / 2.0f;
                    this.yOffset = (float)(previewSize.getHeight() - layoutParams.height) / 2.0f;
                } else {
                    layoutParams.width = previewSize.getWidth();
                    layoutParams.height = previewSize.getHeight();
                }
                this.scalew = HardwareInfo.AMLOGIC ? (float)previewSize.getWidth() / (float)this.camera2Helper.getImgWidth() : (float)previewSize.getWidth() / (float)this.camera2Helper.getImgHeight();
                this.textureView.setLayoutParams(layoutParams);
                ViewGroup.LayoutParams olayoutParams = this.overlay.getLayoutParams();
                olayoutParams.width = layoutParams.width;
                olayoutParams.height = layoutParams.height;
                this.overlay.setLayoutParams(olayoutParams);
                this.isSetTexture2 = false;
            }
            DisplayMetrics displayMetrics = new DisplayMetrics();
            this.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        });
    }

    @Override
    public void onCameraClosed() {
        Log.i((String)TAG, (String)"onCameraClosed() *** Camera Closed *** ");
        this.sendCameraStatus(-1);
    }

    @Override
    public void onCameraError(Exception e) {
        Log.i((String)TAG, (String)"onCameraError() *** Camera Error *** ");
        this.sendCameraStatus(-1);
        this.showToast("\u76f8\u673a\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u5f00\u542f\u76f8\u673a\uff01");
    }

    @Override
    public void setRotAngle(int result) {
    }

    @Override
    public void textureAvailable() {
    }

    protected void onDestroy() {
        if (this.camera2Helper != null) {
            this.camera2Helper.release();
        }
        this.releaseZee();
        if (this.overlay != null) {
            this.overlay.release();
        }
        super.onDestroy();
    }

    private void showToast(String msg) {
        Toast.makeText((Context)this, (CharSequence)msg, (int)0).show();
    }

    public void sendMsgToUnity(String msg) {
        Log.i((String)TAG, (String)("sendMsgToUnity() *** " + msg + " *** "));
        UnityPlayer.UnitySendMessage((String)"receiveObj", (String)"OnAndroidMsg", (String)msg);
    }

    public void OnUnityMsg(int type, String msg) {
        Log.i((String)TAG, (String)("OnUnityMsg() msg=" + msg));
        try {
            JSONObject baseJson = new JSONObject(msg);
            int cmd = baseJson.getInt("cmd");
            if (cmd != 100) {
                if (cmd == 101) {
                    this.handleUnityShowToast(baseJson);
                } else if (cmd == 104) {
                    if (this.unityAuthInfo != null) {
                        this.handleAuthAkSk(baseJson, this.unityAuthInfo);
                    } else {
                        Log.i((String)TAG, (String)"OnUnityMsg wait for 104");
                    }
                }
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("JSONException() " + (Object)((Object)e)));
        }
    }

    private void handleAuthAkSk(JSONObject baseJson, AuthInfo authInfo) throws JSONException {
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("ak", (Object)authInfo.getAkCode());
        bodyJson.put("sk", (Object)authInfo.getSkCode());
        bodyJson.put("hostPkg", (Object)authInfo.getHostPkg());
        bodyJson.put("authUri", (Object)authInfo.getAuthUri());
        bodyJson.put("token", (Object)authInfo.getAuthToken());
        baseJson.put("body", (Object)bodyJson);
        this.sendMsgToUnity(baseJson.toString());
    }

    private void handleUnityShowToast(JSONObject baseJson) throws JSONException {
        JSONObject bodyJson = baseJson.getJSONObject("body");
        String toastMsg = bodyJson.getString("msg");
        if (!toastMsg.isEmpty()) {
            this.showToast(toastMsg);
        }
    }

    private void sendCameraStatus(int status) {
        JSONObject baseJson = new JSONObject();
        try {
            baseJson.put("cmd", 203);
            baseJson.put("seq", 1);
            baseJson.put("state", 0);
            JSONObject bodyJson = new JSONObject();
            bodyJson.put("openCameraStatus", status);
            baseJson.put("body", (Object)bodyJson);
            this.sendMsgToUnity(baseJson.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("JSONException() " + (Object)((Object)e)));
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == 4) {
            System.exit(0);
        }
        return super.dispatchKeyEvent(event);
    }

    @Override
    public void method(Bitmap bitmap) {
        if (this.initZeeResult == 0) {
            if (LocationEnum.PERSONPOSE == this.locationEnum) {
                if (this.useBestPose) {
                    this.bestPersonPoseMethod(bitmap);
                } else if (this.trackIdArray != null && this.trackIdArray.length > 0) {
                    if (this.trackIdArray.length == 1) {
                        this.poseTrackIdInfoMethod(bitmap, this.trackIdArray[0]);
                    } else {
                        this.twoPersonTrackInfoMethod(bitmap, this.trackIdArray[0], this.trackIdArray[1]);
                    }
                } else if (this.roiPersonTrackRect != null) {
                    this.roiPersonTrackInfo(bitmap, this.roiPersonTrackRect);
                } else {
                    this.personPoseMethod(bitmap);
                }
            } else if (LocationEnum.SINGLEPOSE == this.locationEnum) {
                this.singlePoseMethod(bitmap);
            } else if (LocationEnum.FACE == this.locationEnum) {
                this.faceInfoMethod(bitmap);
            } else if (LocationEnum.HAND == this.locationEnum) {
                this.handInfoMethod(bitmap);
            } else if (LocationEnum.HOLISTIC == this.locationEnum) {
                this.holisticInfoMethod(bitmap);
            }
        }
    }

    private void faceInfoMethod(Bitmap bitmap) {
        long startTime = System.currentTimeMillis();
        this.faceInfoOrgArray = this.zeewainPose.getFaceInfo(bitmap);
        if (this.debugAndroid) {
            long endTime = System.currentTimeMillis();
            long costTime = endTime - startTime;
            Log.i((String)TAG, (String)("face costTime:" + costTime + " ms."));
        }
        this.transformFaceInfoToUnity(this.faceInfoOrgArray);
    }

    private void handInfoMethod(Bitmap bitmap) {
        long startTime = System.currentTimeMillis();
        this.handInfoOrgArray = this.zeewainPose.getHandInfo(bitmap);
        if (this.debugAndroid) {
            long endTime = System.currentTimeMillis();
            long costTime = endTime - startTime;
            Log.i((String)TAG, (String)("hand costTime:" + costTime + " ms."));
        }
        this.transformHandInfoToUnity(this.handInfoOrgArray);
    }

    private void bestPersonPoseMethod(Bitmap bitmap) {
        PoseInfo[] poseInfoArray;
        long startTime = System.currentTimeMillis();
        PoseInfo poseInfo = this.zeewainPose.getBestPoseTrackInfo(bitmap);
        if (this.debugAndroid) {
            long endTime = System.currentTimeMillis();
            long costTime = endTime - startTime;
            Log.i((String)TAG, (String)("bestPersonPoseMethod costTime:" + costTime + " ms."));
        }
        if (poseInfo == null) {
            poseInfoArray = null;
        } else {
            PoseInfo[] poseInfoArray2 = new PoseInfo[1];
            poseInfoArray = poseInfoArray2;
            poseInfoArray2[0] = poseInfo;
        }
        this.poseInfoOrgArray = poseInfoArray;
        this.transformPoseToUnity(this.poseInfoOrgArray);
    }

    private void poseTrackIdInfoMethod(Bitmap bitmap, int trackId) {
        PoseInfo[] poseInfoArray;
        long startTime = System.currentTimeMillis();
        PoseInfo poseInfo = this.zeewainPose.getIdPoseTrackIdInfo(bitmap, trackId);
        if (this.debugAndroid) {
            long endTime = System.currentTimeMillis();
            long costTime = endTime - startTime;
            Log.i((String)TAG, (String)("poseTrackIdInfoMethod costTime:" + costTime + " ms."));
        }
        if (poseInfo == null) {
            poseInfoArray = null;
        } else {
            PoseInfo[] poseInfoArray2 = new PoseInfo[1];
            poseInfoArray = poseInfoArray2;
            poseInfoArray2[0] = poseInfo;
        }
        this.poseInfoOrgArray = poseInfoArray;
        this.transformPoseToUnity(this.poseInfoOrgArray);
    }

    private void twoPersonTrackInfoMethod(Bitmap bitmap, int trackLeftId, int trackRightId) {
        long startTime = System.currentTimeMillis();
        this.poseInfoOrgArray = this.zeewainPose.getTwoPersonTrackInfo(bitmap, trackLeftId, trackRightId);
        if (this.debugAndroid) {
            long endTime = System.currentTimeMillis();
            long costTime = endTime - startTime;
            Log.i((String)TAG, (String)("twoPersonTrackInfoMethod costTime:" + costTime + " ms."));
        }
        this.transformPoseToUnity(this.poseInfoOrgArray);
    }

    private void roiPersonTrackInfo(Bitmap bitmap, Rect rect) {
        long startTime = System.currentTimeMillis();
        this.poseInfoOrgArray = this.zeewainPose.getRoiPersonTrackInfo(bitmap, rect);
        if (this.debugAndroid) {
            long endTime = System.currentTimeMillis();
            long costTime = endTime - startTime;
            Log.i((String)TAG, (String)("roiPersonTrackInfo costTime:" + costTime + " ms."));
        }
        this.transformPoseToUnity(this.poseInfoOrgArray);
    }

    private void personPoseMethod(Bitmap bitmap) {
        long startTime = System.currentTimeMillis();
        this.poseInfoOrgArray = this.zeewainPose.getPoseInfo(bitmap);
        if (this.debugAndroid) {
            long endTime = System.currentTimeMillis();
            long costTime = endTime - startTime;
            Log.i((String)TAG, (String)("personPoseMethod costTime:" + costTime + " ms."));
        }
        this.transformPoseToUnity(this.poseInfoOrgArray);
    }

    private void singlePoseMethod(Bitmap bitmap) {
        PoseInfo[] poseInfoArray;
        long startTime = System.currentTimeMillis();
        PoseInfo poseInfo = this.zeewainPose.getSinglePoseInfo(bitmap);
        if (this.debugAndroid) {
            long endTime = System.currentTimeMillis();
            long costTime = endTime - startTime;
            Log.i((String)TAG, (String)("person pose costTime:" + costTime + " ms."));
        }
        if (poseInfo == null) {
            poseInfoArray = null;
        } else {
            PoseInfo[] poseInfoArray2 = new PoseInfo[1];
            poseInfoArray = poseInfoArray2;
            poseInfoArray2[0] = poseInfo;
        }
        this.poseInfoOrgArray = poseInfoArray;
        this.transformPoseToUnity(this.poseInfoOrgArray);
    }

    private void holisticInfoMethod(Bitmap bitmap) {
        long startTime = System.currentTimeMillis();
        this.holisticInfo = this.zeewainPose.GetHolisticInfo(bitmap);
        if (this.debugAndroid) {
            long endTime = System.currentTimeMillis();
            long costTime = endTime - startTime;
            Log.i((String)TAG, (String)("holistic costTime:" + costTime + " ms."));
        }
        if (this.holisticInfo != null) {
            PoseInfo[] poseInfoArray;
            FaceInfo[] faceInfoArray;
            if (this.holisticInfo.faceInfo == null) {
                faceInfoArray = null;
            } else {
                FaceInfo[] faceInfoArray2 = new FaceInfo[1];
                faceInfoArray = faceInfoArray2;
                faceInfoArray2[0] = this.holisticInfo.faceInfo;
            }
            this.faceInfoOrgArray = faceInfoArray;
            this.transformFaceInfoToUnity(this.faceInfoOrgArray);
            if (this.holisticInfo.leftHandInfo != null && this.holisticInfo.rightHandInfo != null) {
                this.handInfoOrgArray = new HandInfo[]{this.holisticInfo.leftHandInfo, this.holisticInfo.rightHandInfo};
                this.transformHandInfoToUnity(this.handInfoOrgArray);
            } else if (this.holisticInfo.leftHandInfo != null) {
                this.handInfoOrgArray = new HandInfo[]{this.holisticInfo.leftHandInfo};
                this.transformHandInfoToUnity(this.handInfoOrgArray);
            } else if (this.holisticInfo.rightHandInfo != null) {
                this.handInfoOrgArray = new HandInfo[]{this.holisticInfo.rightHandInfo};
                this.transformHandInfoToUnity(this.handInfoOrgArray);
            } else {
                this.handInfoOrgArray = null;
                this.handInfoArray = null;
                this.handInfoOverlayArray = null;
            }
            if (this.holisticInfo.poseInfo == null) {
                poseInfoArray = null;
            } else {
                PoseInfo[] poseInfoArray2 = new PoseInfo[1];
                poseInfoArray = poseInfoArray2;
                poseInfoArray2[0] = this.holisticInfo.poseInfo;
            }
            this.poseInfoOrgArray = poseInfoArray;
            this.transformPoseToUnity(this.poseInfoOrgArray);
        } else {
            this.clearAllData();
        }
    }

    public void clearAllData() {
        this.faceInfoOrgArray = null;
        this.faceInfoArray = null;
        this.faceInfoOverlayArray = null;
        this.handInfoOrgArray = null;
        this.handInfoArray = null;
        this.handInfoOverlayArray = null;
        this.poseInfoOrgArray = null;
        this.poseInfoArray = null;
        this.poseInfoOverlayArray = null;
        this.holisticInfo = null;
    }

    private void transformFaceInfoToUnity(FaceInfo[] faceInfoOrgArray) {
        if (faceInfoOrgArray != null && faceInfoOrgArray.length > 0) {
            this.faceInfoArray = new FaceInfo[faceInfoOrgArray.length];
            this.faceInfoOverlayArray = new FaceInfo[faceInfoOrgArray.length];
            for (int j = 0; j < faceInfoOrgArray.length; ++j) {
                this.faceInfoArray[j] = ZeePoseWrapper.cloneFaceInfo(faceInfoOrgArray[j]);
                this.faceInfoOverlayArray[j] = ZeePoseWrapper.cloneFaceInfo(faceInfoOrgArray[j]);
                if (this.faceInfoArray[j].landmarks != null) {
                    for (int i = 0; i < this.faceInfoArray[j].landmarks.length; ++i) {
                        this.faceInfoArray[j].landmarks[i].x = this.faceInfoArray[j].landmarks[i].x * this.scalew - this.xOffset;
                        this.faceInfoArray[j].landmarks[i].y = this.faceInfoArray[j].landmarks[i].y * this.scalew - this.yOffset;
                        this.faceInfoOverlayArray[j].landmarks[i].x = this.faceInfoArray[j].landmarks[i].x;
                        this.faceInfoOverlayArray[j].landmarks[i].y = this.faceInfoArray[j].landmarks[i].y;
                        this.faceInfoArray[j].landmarks[i].x = (int)(((double)this.faceInfoArray[j].landmarks[i].x - (double)this.textureView.getLayoutParams().width * 0.5) * (double)this.androidU3dScale);
                        this.faceInfoArray[j].landmarks[i].y = (int)(((double)this.textureView.getLayoutParams().height * 0.5 - (double)this.faceInfoArray[j].landmarks[i].y) * (double)this.androidU3dScale);
                    }
                }
                if (this.faceInfoArray[j].rect == null) continue;
                float rectX = (float)this.faceInfoArray[j].rect.x * this.scalew - this.xOffset;
                float rectY = (float)this.faceInfoArray[j].rect.y * this.scalew - this.yOffset;
                this.faceInfoOverlayArray[j].rect.x = (int)rectX;
                this.faceInfoOverlayArray[j].rect.y = (int)rectY;
                this.faceInfoOverlayArray[j].rect.width = (int)((float)this.faceInfoOverlayArray[j].rect.width * this.scalew);
                this.faceInfoOverlayArray[j].rect.height = (int)((float)this.faceInfoOverlayArray[j].rect.height * this.scalew);
                this.faceInfoArray[j].rect.width = (int)((float)this.faceInfoArray[j].rect.width * this.androidU3dScale * this.scalew);
                this.faceInfoArray[j].rect.height = (int)((float)this.faceInfoArray[j].rect.height * this.androidU3dScale * this.scalew);
                this.faceInfoArray[j].rect.x = (int)(((double)rectX - (double)this.textureView.getLayoutParams().width * 0.5) * (double)this.androidU3dScale);
                this.faceInfoArray[j].rect.y = (int)(((double)this.textureView.getLayoutParams().height * 0.5 - (double)rectY) * (double)this.androidU3dScale);
                this.faceInfoArray[j].rect.x += this.faceInfoArray[j].rect.width / 2;
                this.faceInfoArray[j].rect.y -= this.faceInfoArray[j].rect.height / 2;
            }
            if (this.debugAndroid) {
                this.runOnUiThread(() -> this.overlay.drawFacePoint(this.faceInfoOverlayArray));
            }
        } else {
            this.faceInfoArray = null;
            this.faceInfoOverlayArray = null;
        }
    }

    private void transformHandInfoToUnity(HandInfo[] handInfoOrgArray) {
        if (handInfoOrgArray != null && handInfoOrgArray.length > 0) {
            this.handInfoArray = new HandInfo[handInfoOrgArray.length];
            this.handInfoOverlayArray = new HandInfo[handInfoOrgArray.length];
            for (int j = 0; j < handInfoOrgArray.length; ++j) {
                this.handInfoArray[j] = ZeePoseWrapper.cloneHandInfo(handInfoOrgArray[j]);
                this.handInfoOverlayArray[j] = ZeePoseWrapper.cloneHandInfo(handInfoOrgArray[j]);
                if (this.handInfoArray[j].landmarks != null) {
                    for (int i = 0; i < this.handInfoArray[j].landmarks.length; ++i) {
                        this.handInfoArray[j].landmarks[i].x = this.handInfoArray[j].landmarks[i].x * this.scalew - this.xOffset;
                        this.handInfoArray[j].landmarks[i].y = this.handInfoArray[j].landmarks[i].y * this.scalew - this.yOffset;
                        this.handInfoOverlayArray[j].landmarks[i].x = this.handInfoArray[j].landmarks[i].x;
                        this.handInfoOverlayArray[j].landmarks[i].y = this.handInfoArray[j].landmarks[i].y;
                        this.handInfoArray[j].landmarks[i].x = (int)(((double)this.handInfoArray[j].landmarks[i].x - (double)this.textureView.getLayoutParams().width * 0.5) * (double)this.androidU3dScale);
                        this.handInfoArray[j].landmarks[i].y = (int)(((double)this.textureView.getLayoutParams().height * 0.5 - (double)this.handInfoArray[j].landmarks[i].y) * (double)this.androidU3dScale);
                    }
                }
                if (this.handInfoArray[j].rect == null) continue;
                float rectX = (float)this.handInfoArray[j].rect.x * this.scalew - this.xOffset;
                float rectY = (float)this.handInfoArray[j].rect.y * this.scalew - this.yOffset;
                this.handInfoOverlayArray[j].rect.x = (int)rectX;
                this.handInfoOverlayArray[j].rect.y = (int)rectY;
                this.handInfoOverlayArray[j].rect.width = (int)((float)this.handInfoOverlayArray[j].rect.width * this.scalew);
                this.handInfoOverlayArray[j].rect.height = (int)((float)this.handInfoOverlayArray[j].rect.height * this.scalew);
                this.handInfoArray[j].rect.x = (int)(((double)rectX - (double)this.textureView.getLayoutParams().width * 0.5) * (double)this.androidU3dScale);
                this.handInfoArray[j].rect.y = (int)(((double)this.textureView.getLayoutParams().height * 0.5 - (double)rectY) * (double)this.androidU3dScale);
                this.handInfoArray[j].rect.width = (int)((float)this.handInfoArray[j].rect.width * this.androidU3dScale * this.scalew);
                this.handInfoArray[j].rect.height = (int)((float)this.handInfoArray[j].rect.height * this.androidU3dScale * this.scalew);
                this.handInfoArray[j].rect.x += this.handInfoArray[j].rect.width / 2;
                this.handInfoArray[j].rect.y -= this.handInfoArray[j].rect.height / 2;
            }
            if (this.debugAndroid) {
                this.runOnUiThread(() -> this.overlay.drawHandPoint(this.handInfoOverlayArray));
            }
        } else {
            this.handInfoArray = null;
            this.handInfoOverlayArray = null;
        }
    }

    private void transformPoseToUnity(PoseInfo[] poseInfoOrgArray) {
        if (poseInfoOrgArray != null && poseInfoOrgArray.length > 0) {
            this.poseInfoArray = new PoseInfo[poseInfoOrgArray.length];
            if (this.debugAndroid) {
                this.poseInfoOverlayArray = new PoseInfo[poseInfoOrgArray.length];
            }
            for (int j = 0; j < poseInfoOrgArray.length; ++j) {
                this.poseInfoArray[j] = ZeePoseWrapper.clonePoseInfo(poseInfoOrgArray[j]);
                if (this.debugAndroid) {
                    this.poseInfoOverlayArray[j] = ZeePoseWrapper.clonePoseInfo(poseInfoOrgArray[j]);
                }
                if (this.poseInfoArray[j].landmarks != null) {
                    for (int i = 0; i < this.poseInfoArray[j].landmarks.length; ++i) {
                        this.poseInfoArray[j].landmarks[i].x = this.poseInfoArray[j].landmarks[i].x * this.scalew - this.xOffset;
                        this.poseInfoArray[j].landmarks[i].y = this.poseInfoArray[j].landmarks[i].y * this.scalew - this.yOffset;
                        if (this.debugAndroid) {
                            this.poseInfoOverlayArray[j].landmarks[i].x = this.poseInfoArray[j].landmarks[i].x;
                            this.poseInfoOverlayArray[j].landmarks[i].y = this.poseInfoArray[j].landmarks[i].y;
                        }
                        this.poseInfoArray[j].landmarks[i].x = (int)(((double)this.poseInfoArray[j].landmarks[i].x - (double)this.textureView.getLayoutParams().width * 0.5) * (double)this.androidU3dScale);
                        this.poseInfoArray[j].landmarks[i].y = (int)(((double)this.textureView.getLayoutParams().height * 0.5 - (double)this.poseInfoArray[j].landmarks[i].y) * (double)this.androidU3dScale);
                    }
                }
                if (this.poseInfoArray[j].rect == null) continue;
                float rectX = (float)this.poseInfoArray[j].rect.x * this.scalew - this.xOffset;
                float rectY = (float)this.poseInfoArray[j].rect.y * this.scalew - this.yOffset;
                if (this.debugAndroid) {
                    this.poseInfoOverlayArray[j].rect.x = (int)rectX;
                    this.poseInfoOverlayArray[j].rect.y = (int)rectY;
                    this.poseInfoOverlayArray[j].rect.width = (int)((float)this.poseInfoOverlayArray[j].rect.width * this.scalew);
                    this.poseInfoOverlayArray[j].rect.height = (int)((float)this.poseInfoOverlayArray[j].rect.height * this.scalew);
                }
                this.poseInfoArray[j].rect.x = (int)(((double)rectX - (double)this.textureView.getLayoutParams().width * 0.5) * (double)this.androidU3dScale);
                this.poseInfoArray[j].rect.y = (int)(((double)this.textureView.getLayoutParams().height * 0.5 - (double)rectY) * (double)this.androidU3dScale);
                this.poseInfoArray[j].rect.width = (int)((float)this.poseInfoArray[j].rect.width * this.androidU3dScale * this.scalew);
                this.poseInfoArray[j].rect.height = (int)((float)this.poseInfoArray[j].rect.height * this.androidU3dScale * this.scalew);
                this.poseInfoArray[j].rect.x += this.poseInfoArray[j].rect.width / 2;
                this.poseInfoArray[j].rect.y -= this.poseInfoArray[j].rect.height / 2;
            }
            if (this.debugAndroid) {
                this.runOnUiThread(() -> this.overlay.drawPosePoint(this.poseInfoOverlayArray));
            }
        } else {
            this.poseInfoArray = null;
            this.poseInfoOverlayArray = null;
        }
    }

    public FaceInfo[] getFaceInfoArray() {
        return this.faceInfoArray;
    }

    public FaceInfo[] getFaceInfoOrgArray() {
        return this.faceInfoOrgArray;
    }

    public HandInfo[] getHandInfoArray() {
        return this.handInfoArray;
    }

    public HandInfo[] getHandInfoOrgArray() {
        return this.handInfoOrgArray;
    }

    public PoseInfo[] getPoseInfoArray() {
        return this.poseInfoArray;
    }

    public float[] getZeePointArray(String str) {
        return null;
    }

    public PoseInfo[] getPoseInfoOrgArray() {
        return this.poseInfoOrgArray;
    }

    public HolisticInfo getHolisticInfo() {
        if (this.holisticInfo != null) {
            PoseInfo poseInfo = this.poseInfoArray == null ? null : this.poseInfoArray[0];
            FaceInfo faceInfo = this.faceInfoArray == null ? null : this.faceInfoArray[0];
            HandInfo leftHandInfo = null;
            HandInfo rightHandInfo = null;
            if (this.handInfoArray != null) {
                if (this.handInfoArray.length > 0) {
                    leftHandInfo = this.handInfoArray[0];
                }
                if (this.handInfoArray.length > 1) {
                    rightHandInfo = this.handInfoArray[1];
                }
            }
            return new HolisticInfo(poseInfo, leftHandInfo, rightHandInfo, faceInfo);
        }
        return null;
    }

    public HolisticInfo getHolisticInfoOrg() {
        if (this.holisticInfo != null) {
            PoseInfo poseInfo = this.poseInfoOrgArray == null ? null : this.poseInfoOrgArray[0];
            FaceInfo faceInfo = this.faceInfoOrgArray == null ? null : this.faceInfoOrgArray[0];
            HandInfo leftHandInfo = null;
            HandInfo rightHandInfo = null;
            if (this.handInfoOrgArray != null) {
                if (this.handInfoOrgArray.length > 0) {
                    leftHandInfo = this.handInfoOrgArray[0];
                }
                if (this.handInfoOrgArray.length > 1) {
                    rightHandInfo = this.handInfoOrgArray[1];
                }
            }
            return new HolisticInfo(poseInfo, leftHandInfo, rightHandInfo, faceInfo);
        }
        return null;
    }

    public void setDebugAndroid(boolean debugAndroid) {
        this.debugAndroid = debugAndroid;
        if (!debugAndroid) {
            if (this.frameLayout.getChildCount() == 4 && this.frameLayout.getChildAt(3) instanceof LinearLayout) {
                this.frameLayout.removeViewAt(3);
            }
        } else if (this.frameLayout.getChildCount() == 3) {
            this.addDebugBtn();
        }
    }
}

