/*
 * Decompiled with CFR 0.152.
 */
package com.zee.unity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.zee.unity.LocationEnum;
import com.zeewain.zeepose.FaceInfo;
import com.zeewain.zeepose.HandInfo;
import com.zeewain.zeepose.PoseInfo;
import com.zeewain.zeepose.base.Point2f;
import com.zeewain.zeepose.base.Point3f;
import java.util.ArrayList;

public class Overlay
extends View {
    private static final String TAG = "zeepose";
    private static final int HANDPOINTNUM = 21;
    private static final int POSEPOINTNUM1 = 17;
    private static final int POSEPOINTNUM2 = 29;
    private static final int POSEPOINTNUM3 = 33;
    private FaceInfo[] faceInfos = null;
    private HandInfo[] handInfos = null;
    private PoseInfo[] poseInfos = null;
    private ArrayList<Point3f> handPoint;
    private int[][] handLineIndex = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 4}, {0, 5}, {5, 6}, {6, 7}, {7, 8}, {5, 9}, {9, 10}, {10, 11}, {11, 12}, {9, 13}, {13, 14}, {14, 15}, {15, 16}, {13, 17}, {0, 17}, {17, 18}, {18, 19}, {19, 20}};
    private ArrayList<Point3f> posePoint;
    private int[][] pose17Index = new int[][]{{0, 2}, {2, 4}, {0, 1}, {1, 3}, {5, 6}, {5, 7}, {7, 9}, {6, 8}, {8, 10}, {6, 12}, {5, 11}, {11, 12}, {11, 13}, {13, 15}, {12, 14}, {14, 16}};
    private int[][] pose29Index = new int[][]{{0, 2}, {2, 4}, {0, 1}, {1, 3}, {5, 6}, {5, 7}, {7, 9}, {9, 15}, {9, 13}, {9, 11}, {6, 8}, {8, 10}, {10, 12}, {10, 14}, {10, 16}, {17, 18}, {6, 18}, {18, 20}, {20, 22}, {5, 17}, {17, 19}, {19, 21}, {22, 24}, {24, 26}, {22, 28}, {21, 23}, {21, 25}, {21, 27}};
    private int[][] pose33Index = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 7}, {0, 4}, {4, 5}, {5, 6}, {6, 8}, {9, 10}, {11, 13}, {13, 15}, {15, 21}, {15, 17}, {15, 19}, {17, 19}, {12, 14}, {14, 16}, {16, 22}, {16, 18}, {16, 20}, {20, 22}, {11, 23}, {23, 25}, {25, 27}, {27, 29}, {27, 31}, {29, 31}, {12, 24}, {24, 26}, {26, 28}, {28, 30}, {28, 32}, {30, 32}, {11, 12}, {23, 24}};
    private LocationEnum location = null;
    private final Paint circlePaint = new Paint();
    private final Paint rectPaint = new Paint();
    private final Paint linePaint = new Paint();

    public Overlay(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void initOverlay(LocationEnum locationEnum) {
        this.location = locationEnum;
        this.circlePaint.setAntiAlias(true);
        this.circlePaint.setColor(-16711936);
        this.circlePaint.setStrokeWidth(10.0f);
        this.circlePaint.setStyle(Paint.Style.STROKE);
        this.rectPaint.setColor(-16711936);
        this.rectPaint.setStrokeWidth(4.0f);
        this.rectPaint.setStyle(Paint.Style.STROKE);
        this.linePaint.setColor(-16776961);
        this.linePaint.setStrokeWidth(4.0f);
        this.linePaint.setStyle(Paint.Style.FILL);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Paint paint = new Paint();
        paint.setColor(-16711936);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(4.0f);
        Paint textpaint = new Paint();
        textpaint.setColor(-16776961);
        textpaint.setTextSize(32.0f);
        textpaint.setTextAlign(Paint.Align.LEFT);
        switch (this.location) {
            case FACE: {
                if (this.faceInfos == null) break;
                for (FaceInfo faceInfo : this.faceInfos) {
                    if (faceInfo.rect == null) continue;
                    float x1 = faceInfo.rect.x;
                    float f = faceInfo.rect.y;
                    float x2 = x1 + (float)faceInfo.rect.width;
                    float y2 = f + (float)faceInfo.rect.height;
                    canvas.drawRect(new Rect((int)x1, (int)f, (int)x2, (int)y2), this.rectPaint);
                }
                break;
            }
            case HAND: {
                if (this.handInfos == null) break;
                for (HandInfo handInfo : this.handInfos) {
                    if (this.handPoint != null) {
                        this.handPoint.clear();
                    }
                    this.handPoint = new ArrayList();
                    Point2f[] landmarks = handInfo.landmarks;
                    if (landmarks != null) {
                        for (Point2f landmark : landmarks) {
                            float x = landmark.x;
                            float y = landmark.y;
                            canvas.drawCircle(x, y, 2.0f, this.circlePaint);
                            this.handPoint.add(new Point3f(x, y, 0.0f));
                        }
                    }
                    if (this.handPoint.size() == 21) {
                        for (int[] index : this.handLineIndex) {
                            canvas.drawLine(this.handPoint.get((int)index[0]).x, this.handPoint.get((int)index[0]).y, this.handPoint.get((int)index[1]).x, this.handPoint.get((int)index[1]).y, this.linePaint);
                        }
                    }
                    if (handInfo.rect == null) continue;
                    float f = handInfo.rect.x;
                    float y1 = handInfo.rect.y;
                    float x2 = f + (float)handInfo.rect.width;
                    float y2 = y1 + (float)handInfo.rect.height;
                    canvas.drawRect(new Rect((int)f, (int)y1, (int)x2, (int)y2), this.rectPaint);
                }
                break;
            }
            case SINGLEPOSE: 
            case PERSONPOSE: {
                if (this.poseInfos == null) break;
                for (PoseInfo poseInfo : this.poseInfos) {
                    Point2f[] landmarks;
                    if (this.posePoint != null) {
                        this.posePoint.clear();
                    }
                    this.posePoint = new ArrayList();
                    for (Point2f landmark : landmarks = poseInfo.landmarks) {
                        float x = landmark.x;
                        float y = landmark.y;
                        canvas.drawCircle(x, y, 2.0f, this.circlePaint);
                        this.posePoint.add(new Point3f(x, y, 0.0f));
                    }
                    this.linePaint.setColor(-16711936);
                    if (this.posePoint.size() == 17) {
                        for (int[] index : this.pose17Index) {
                            canvas.drawLine(this.posePoint.get((int)index[0]).x, this.posePoint.get((int)index[0]).y, this.posePoint.get((int)index[1]).x, this.posePoint.get((int)index[1]).y, this.linePaint);
                        }
                        continue;
                    }
                    if (this.posePoint.size() == 29) {
                        for (int[] index : this.pose29Index) {
                            canvas.drawLine(this.posePoint.get((int)index[0]).x, this.posePoint.get((int)index[0]).y, this.posePoint.get((int)index[1]).x, this.posePoint.get((int)index[1]).y, this.linePaint);
                        }
                        continue;
                    }
                    if (this.posePoint.size() != 33) continue;
                    for (int[] index : this.pose33Index) {
                        canvas.drawLine(this.posePoint.get((int)index[0]).x, this.posePoint.get((int)index[0]).y, this.posePoint.get((int)index[1]).x, this.posePoint.get((int)index[1]).y, this.linePaint);
                    }
                }
                break;
            }
        }
    }

    public void drawFacePoint(FaceInfo[] faceInfos) {
        this.location = LocationEnum.FACE;
        this.faceInfos = faceInfos;
        this.invalidate();
    }

    public void drawHandPoint(HandInfo[] handInfos) {
        this.location = LocationEnum.HAND;
        this.handInfos = handInfos;
        this.invalidate();
    }

    public void drawPosePoint(PoseInfo[] poseInfos) {
        this.location = LocationEnum.PERSONPOSE;
        this.poseInfos = poseInfos;
        this.invalidate();
    }

    public void release() {
        this.faceInfos = null;
        this.handInfos = null;
        this.poseInfos = null;
        if (this.handPoint != null) {
            this.handPoint.clear();
        }
    }
}

