var weixin_jssdk_ops = {
    init: function (share_opts) {
        this.initJSconfig(share_opts);
    },
    initJSconfig: function (share_opts) {
        $.ajax({
            url: '//wd.leiting.com/api/wechat',
            data: {
        		url : share_opts.url,
        		key : share_opts.key
        	},
            type: 'get',
            dataType: 'jsonp',
			jsonp:"jsonpcallback",
            success: function (data) {
                if (data.status == 'success') {
                    var appId = data.message.appId;
                    var timestamp = data.message.timestamp;
                    var nonceStr = data.message.nonceStr;
                    var signature = data.message.signature;
                    wx.config({
                        debug: false,
                        appId: appId,
                        timestamp: timestamp,
                        nonceStr: nonceStr,
                        signature: signature,
                        jsApiList: [
                            'onMenuShareTimeline', 'onMenuShareAppMessage'
                        ]
                    });
                    weixin_jssdk_ops.ready(share_opts);
                    wx.error(function (res) {
                        console.log(res);
                    });
                }
            }
        });
    },
    ready: function(share_opts){
        wx.ready(function () {
            if (!share_opts.link) {
            	share_opts.link = share_opts.url;
			}
            wx.onMenuShareTimeline({
                title: share_opts.title,
                imgUrl: share_opts.img,
                link: share_opts.link,
                success: function () {
            		if(MtaH5){
            			MtaH5.clickStat("weixin")
            			MtaH5.clickShare('wechat_moments');
            		}
                }
            });
            wx.onMenuShareAppMessage({
                title: share_opts.title,
                desc: share_opts.desc,
                link: share_opts.link,
                imgUrl: share_opts.img,
                type: 'link',
                success: function () {
            		if(MtaH5){
            			MtaH5.clickStat("weixin")
            			MtaH5.clickShare('wechat_friend');
            		}
                }
            });
        });
    }
};